/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.WorkflowProcess;
import org.drools.runtime.process.EventListener;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowProcessInstanceImpl
extends ProcessInstanceImpl
implements WorkflowProcessInstance,
NodeInstanceContainer {
    private static final long serialVersionUID = 510L;
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private long nodeInstanceCounter = 0L;
    private Map<String, List<EventListener>> eventListeners = new HashMap<String, List<EventListener>>();
    private Map<String, List<EventListener>> externalEventListeners = new HashMap<String, List<EventListener>>();

    @Override
    public NodeContainer getNodeContainer() {
        return this.getWorkflowProcess();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        ((NodeInstanceImpl)nodeInstance).setId(this.nodeInstanceCounter++);
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        if (((NodeInstanceImpl)nodeInstance).isInversionOfControl()) {
            this.getKnowledgeRuntime().retract(this.getKnowledgeRuntime().getFactHandle(nodeInstance));
        }
        this.nodeInstances.remove(nodeInstance);
    }

    @Override
    public Collection<org.drools.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<org.drools.runtime.process.NodeInstance>(this.getNodeInstances(false));
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof org.drools.runtime.process.NodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public NodeInstance getNodeInstance(long nodeInstanceId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getId() != nodeInstanceId) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<String> getActiveNodeIds() {
        ArrayList<String> result = new ArrayList<String>();
        this.addActiveNodeIds(this, result);
        return result;
    }

    private void addActiveNodeIds(org.drools.runtime.process.NodeInstanceContainer container, List<String> result) {
        for (org.drools.runtime.process.NodeInstance nodeInstance : container.getNodeInstances()) {
            result.add(((NodeImpl)((NodeInstanceImpl)nodeInstance).getNode()).getUniqueId());
            if (!(nodeInstance instanceof org.drools.runtime.process.NodeInstanceContainer)) continue;
            this.addActiveNodeIds((org.drools.runtime.process.NodeInstanceContainer)((Object)nodeInstance), result);
        }
    }

    @Override
    public NodeInstance getFirstNodeInstance(long nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<NodeInstance> getNodeInstances(long nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        NodeInstanceFactory conf = NodeInstanceFactoryRegistry.INSTANCE.getProcessNodeInstanceFactory(node);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(node, this, this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        if (nodeInstance.isInversionOfControl()) {
            this.getKnowledgeRuntime().insert(nodeInstance);
        }
        return nodeInstance;
    }

    public long getNodeInstanceCounter() {
        return this.nodeInstanceCounter;
    }

    public void internalSetNodeInstanceCounter(long nodeInstanceCounter) {
        this.nodeInstanceCounter = nodeInstanceCounter;
    }

    public WorkflowProcess getWorkflowProcess() {
        return (WorkflowProcess)this.getProcess();
    }

    @Override
    public Object getVariable(String name) {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances != null && variableScopeInstances.size() == 1) {
                for (ContextInstance contextInstance : variableScopeInstances) {
                    Object value = ((VariableScopeInstance)contextInstance).getVariable(name);
                    if (value == null) continue;
                    return value;
                }
            }
            return null;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariable(name);
    }

    public Map<String, Object> getVariables() {
        if (this.getKnowledgeRuntime() == null) {
            List<ContextInstance> variableScopeInstances = this.getContextInstances("VariableScope");
            if (variableScopeInstances == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (ContextInstance contextInstance : variableScopeInstances) {
                Map<String, Object> variables = ((VariableScopeInstance)contextInstance).getVariables();
                result.putAll(variables);
            }
            return result;
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariables();
    }

    @Override
    public void setVariable(String name, Object value) {
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            throw new IllegalArgumentException("No variable scope found.");
        }
        variableScopeInstance.setVariable(name, value);
    }

    @Override
    public void setState(int state) {
        super.setState(state);
        if (state == 2 || state == 3) {
            InternalKnowledgeRuntime kruntime = this.getKnowledgeRuntime();
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)kruntime.getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeProcessCompleted(this, kruntime);
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
            this.removeEventListeners();
            processRuntime.getProcessInstanceManager().removeProcessInstance(this);
            processRuntime.getProcessEventSupport().fireAfterProcessCompleted(this, kruntime);
            processRuntime.getSignalManager().signalEvent("processInstanceCompleted:" + this.getId(), this);
        }
    }

    @Override
    public void disconnect() {
        this.removeEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof StateBasedNodeInstance)) continue;
            ((StateBasedNodeInstance)nodeInstance).removeEventListeners();
        }
        super.disconnect();
    }

    @Override
    public void reconnect() {
        super.reconnect();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
        this.addEventListeners();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WorkflowProcessInstance");
        sb.append(this.getId());
        sb.append(" [processId=");
        sb.append(this.getProcessId());
        sb.append(",state=");
        sb.append(this.getState());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            this.registerExternalEventNodeListeners();
            super.start();
        }
    }

    private void registerExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (!(node instanceof EventNode) || !"external".equals(((EventNode)node).getScope())) continue;
            this.addEventListener(((EventNode)node).getType(), new ExternalEventListener(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEvent(String type, Object event) {
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            if (this.getState() != 1) {
                return;
            }
            List<EventListener> listeners = this.eventListeners.get(type);
            if (listeners != null) {
                for (EventListener listener : listeners) {
                    listener.signalEvent(type, event);
                }
            }
            if ((listeners = this.externalEventListeners.get(type)) != null) {
                for (EventListener listener : listeners) {
                    listener.signalEvent(type, event);
                }
            }
            for (Node node : this.getWorkflowProcess().getNodes()) {
                if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)((Object)node)).acceptsEvent(type, event)) continue;
                if (node instanceof EventNode && ((EventNode)node).getFrom() == null) {
                    EventNodeInstance eventNodeInstance = (EventNodeInstance)this.getNodeInstance(node);
                    eventNodeInstance.signalEvent(type, event);
                    continue;
                }
                List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId());
                if (nodeInstances == null || nodeInstances.isEmpty()) continue;
                for (NodeInstance nodeInstance : nodeInstances) {
                    ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event);
                }
            }
            if (((org.jbpm.workflow.core.WorkflowProcess)this.getWorkflowProcess()).isDynamic()) {
                for (Node node : this.getWorkflowProcess().getNodes()) {
                    if (!type.equals(node.getName()) || !node.getIncomingConnections().isEmpty()) continue;
                    NodeInstance nodeInstance = this.getNodeInstance(node);
                    nodeInstance.trigger(null, "DROOLS_DEFAULT");
                }
            }
        }
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List<EventListener> listeners = eventListeners.get(type);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<EventListener>();
            eventListeners.put(type, listeners);
            if (external) {
                ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().addEventListener(type, this);
            }
        }
        listeners.add(listener);
    }

    @Override
    public void removeEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List<EventListener> listeners = eventListeners.get(type);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                eventListeners.remove(type);
                if (external) {
                    ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, this);
                }
            }
        }
    }

    private void addEventListeners() {
        this.registerExternalEventNodeListeners();
    }

    private void removeEventListeners() {
        for (String type : this.externalEventListeners.keySet()) {
            ((InternalProcessRuntime)this.getKnowledgeRuntime().getProcessRuntime()).getSignalManager().removeEventListener(type, this);
        }
    }

    @Override
    public String[] getEventTypes() {
        return this.externalEventListeners.keySet().toArray(new String[this.externalEventListeners.size()]);
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        if (nodeInstance instanceof EndNodeInstance || ((org.jbpm.workflow.core.WorkflowProcess)this.getWorkflowProcess()).isDynamic()) {
            if (((org.jbpm.workflow.core.WorkflowProcess)this.getProcess()).isAutoComplete() && this.nodeInstances.isEmpty()) {
                this.setState(2);
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection not suppoerted.");
        }
    }

    private class ExternalEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 5L;

        private ExternalEventListener() {
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
        }
    }
}

